#!/bin/bash

prefix="results/advgluepp"
weak_model_size="14m"
weak_model_title="14M"
strong_model_size="6p9b"
strong_model_title="6.9B"
lambda_value="0p3"
alpha_value="0p1"
num_epochs=6

python avg_performance.py ${prefix}/phase-1/alpha-${alpha_value}/pythia-${weak_model_size}-${strong_model_size}-ep${num_epochs} ${prefix}/avg/lambda-${lambda_value}/alpha-${alpha_value} 'Phase 1'
python avg_performance.py ${prefix}/phase-2/lambda-${lambda_value}/alpha-${alpha_value}/pythia-${weak_model_size}-${strong_model_size}-ep${num_epochs} ${prefix}/avg/lambda-${lambda_value}/alpha-${alpha_value} 'Phase 2'
python avg_performance.py ${prefix}/phase-3/lambda-${lambda_value}/alpha-${alpha_value}/pythia-${weak_model_size}-${strong_model_size}-ep${num_epochs} ${prefix}/avg/lambda-${lambda_value}/alpha-${alpha_value} 'Phase 3'

# python plot/main_plot.py ${prefix}/avg/lambda-${lambda_value}/alpha-${alpha_value}/pythia-${weak_model_size}-${strong_model_size}-ep${num_epochs} --avg --title "${weak_model_title} vs ${strong_model_title} Original Performance" --category original
# python plot/main_plot.py ${prefix}/avg/lambda-${lambda_value}/alpha-${alpha_value}/pythia-${weak_model_size}-${strong_model_size}-ep${num_epochs} --avg --title "${weak_model_title} vs ${strong_model_title} Adversarial Performance" --category adversarial
python plot/main_plot.py ${prefix}/avg/lambda-${lambda_value}/alpha-${alpha_value}/pythia-${weak_model_size}-${strong_model_size}-ep${num_epochs} --avg